package gov.va.med.mhv.sm.api.transfer;

import gov.va.med.mhv.sm.api.util.DisplayUtil;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@XmlRootElement(name = "Attachment")
@JsonIgnoreProperties
@JsonSerialize(include= JsonSerialize.Inclusion.NON_NULL)
public class AttachmentTO implements Serializable {
	private static final long serialVersionUID = -6862213203034285918L;

	private long id;
	private String name;
	private long attachmentSize;
	
	public AttachmentTO() {
	}

	public AttachmentTO(long id, String name) {
		this.id = id;
		this.name = name;
	}
	
	public AttachmentTO(long id, String name, long attachmentSize) {
		this.id = id;
		this.name = name;
		this.attachmentSize = attachmentSize;
	}

	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public long getAttachmentSize() {
		return attachmentSize;
	}
	@JsonIgnore
	public String getAttachmentSizeStr() {
		return DisplayUtil.formatFileSize(attachmentSize);
	}
	public void setAttachmentSize(long attachmentSize) {
		this.attachmentSize = attachmentSize;
	}
	

}
